<?php
/* --------------------------------------------------------------
 LoadAdminShopConfiguration.php 2020-03-30
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Kernel\Bootstrapper;

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Server;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;

require_once __DIR__ . '/../../../../admin/includes/configure.php';

/**
 * Class LoadAdminShopConfiguration
 * @package Gambio\Admin\Application\Kernel\Bootstrapper
 */
class LoadAdminShopConfiguration extends AbstractBootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $host             = HTTP_SERVER;
        $webPath          = rtrim(DIR_WS_CATALOG, '/');
        $serverPath       = rtrim(DIR_FS_CATALOG, '/');
        
        $isSslEnabled = strtolower(ENABLE_SSL_CATALOG) === 'true';
        $requestUri   = $_SERVER['REQUEST_URI'];
        
        $application->share(Path::class)->addArgument($serverPath);
        $application->share(Url::class)->addArgument($host)->addArgument($webPath);
        $application->share(Server::class)->addArgument($isSslEnabled)->addArgument($requestUri);
    }
}